import type { NextApiResponse, NextApiRequest } from "next";
import { getServerSession } from "next-auth";
import { authOptions } from "@/lib/authOptions";

export async function requireAdmin(req: NextApiRequest, res: NextApiResponse) {
  const session = await getServerSession(req, res, authOptions);
  const role = (session?.user as any)?.role;
  if (!session?.user?.id || role !== "ADMIN") {
    res.status(403).json({ ok: false, error: "Admin only" });
    return null;
  }
  return session;
}
